(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     45819,       1219]
NotebookOptionsPosition[     42916,       1118]
NotebookOutlinePosition[     43448,       1137]
CellTagsIndexPosition[     43405,       1134]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["01 Vectors", "Title",
 CellChangeTimes->{{3.543847653428233*^9, 3.5438476603879285`*^9}}],

Cell["\<\
Submit your completed work by placing this file in your folder of M:\\Classes\
\\MATH213.\
\>", "Text",
 CellChangeTimes->{{3.543847682631153*^9, 3.543847690566946*^9}, {
  3.5442904675915427`*^9, 3.5442905126305428`*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Introduction"
}], "Section",
 CellChangeTimes->{{3.5438457632552347`*^9, 3.543845768166725*^9}}],

Cell[CellGroupData[{

Cell["Exercise 1", "Subsection",
 CellChangeTimes->{{3.543848529190366*^9, 3.543848532397045*^9}}],

Cell[TextData[{
 "Consider the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"cos", "(", 
      RowBox[{"2", "x"}], ")"}]}]}], TraditionalForm]]],
 ".  Find the exact value and a numerical approximation of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "4", ")"}], TraditionalForm]]],
 ".  Graph ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 " on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "]"}], TraditionalForm]]],
 ".  Find ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "'"}], 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "2"}], "2"], 
    RowBox[{
     RowBox[{"f", "(", "x", ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]]],
 " ."
}], "Text",
 CellChangeTimes->{{3.543848544460839*^9, 3.54384854665162*^9}, {
  3.543848614069877*^9, 3.5438489371811056`*^9}, {3.5438494653751054`*^9, 
  3.543849467022105*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"y", "=", 
   RowBox[{
    SuperscriptBox["x", "3"], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", "x"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"y", "/.", 
  RowBox[{"x", "\[Rule]", "4"}]}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"D", "[", "y", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{"y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5438489462161055`*^9, 3.5438490370001054`*^9}, 
   3.5438496182251053`*^9}],

Cell[BoxData[
 RowBox[{"64", "-", 
  RowBox[{"Cos", "[", "8", "]"}]}]], "Output",
 CellChangeTimes->{3.543849038411105*^9, 3.5438496198321056`*^9}],

Cell[BoxData["64.14550003380862`"], "Output",
 CellChangeTimes->{3.543849038411105*^9, 3.5438496198351054`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtmXk0VP//x0WWygdtouxlSRIRWd8T0kqypciaJVpFVEKSbJUUCaFEtihL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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageSize->{188.6666666666666, Automatic},
  PlotRange->{{-2, 2}, {-7.346355275985009, 8.653642764831398}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.543849038411105*^9, 3.5438496198621054`*^9}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "3"], "-", 
  RowBox[{"Cos", "[", 
   RowBox[{"2", " ", "x"}], "]"}]}]], "Output",
 CellChangeTimes->{3.543849038411105*^9, 3.543849619864105*^9}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Sin", "[", "4", "]"}]}]], "Output",
 CellChangeTimes->{3.543849038411105*^9, 3.5438496198961053`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2", "Subsection",
 CellChangeTimes->{{3.543849497517105*^9, 3.543849500588105*^9}}],

Cell[TextData[{
 "Attempt to find an approximate solution to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", "0"}], TraditionalForm]]],
 " using the ",
 StyleBox["NSolve", "Input"],
 " function.  "
}], "Text",
 CellChangeTimes->{{3.543849503918105*^9, 3.5438497328441057`*^9}, 
   3.5438497678611054`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"y", "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{3.543849624958105*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NSolve", "::", "nsmet"}], "MessageName"], ":", 
  " ", "\<\"This system cannot be solved with the methods available to \
NSolve. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/NSolve\\\", ButtonNote -> \
\\\"NSolve::nsmet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.5438496257431054`*^9}],

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}]}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Output",
 CellChangeTimes->{3.5438496257441053`*^9}]
}, Open  ]],

Cell[TextData[{
 "When that does not work, place the cursor on ",
 StyleBox["NSolve", "Input"],
 " and press the ",
 Cell[BoxData[
  FormBox["F1", TraditionalForm]]],
 " key or select Help | Find Selected Function.  This should open a help page \
on NSolve.  Notice the numerous examples showing how to use the NSolve \
function.  Click on the ",
 Cell[BoxData[
  FormBox[
   FrameBox[
    RowBox[{
     RowBox[{"See", " ", "Also"}], " ", ">>"}]], TraditionalForm]]],
 "  button and explore until you find a function that can find an approximate \
solution to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", "0"}], TraditionalForm]]],
 ".  Do it!"
}], "Text",
 CellChangeTimes->{{3.5438497719661055`*^9, 3.5438499613981056`*^9}, {
  3.543850058524105*^9, 3.543850063397105*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"y", "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", ".6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.543849988371105*^9, 3.5438500020941057`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "0.6477654334582033`"}], "}"}]], "Output",
 CellChangeTimes->{3.543850003194105*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vectors in the Plane", "Section",
 CellChangeTimes->{{3.543844327991749*^9, 3.543844329173684*^9}, {
  3.5438513565971055`*^9, 3.5438513585001054`*^9}}],

Cell[CellGroupData[{

Cell["Exercise 3", "Subsection",
 CellChangeTimes->{{3.5442233059790325`*^9, 3.544223308328167*^9}}],

Cell[TextData[{
 "Choose a variety of values for u, v, a, b, m, and n in the above commands \
to investigate the following.  Give a precise geometric description of the \
relationship among the vectors ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", " ", 
     StyleBox["u",
      FontWeight->"Bold"]}], "+", 
    RowBox[{"b", " ", 
     StyleBox["v",
      FontWeight->"Bold"]}]}], TraditionalForm]]],
 ".  State what choices of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 " it would ",
 StyleBox["not",
  FontVariations->{"Underline"->True}],
 " be possible to obtain all vectors (with base at the origin) as a linear \
combination of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.544223401344487*^9, 3.5442235161610537`*^9}, {
  3.544223719911708*^9, 3.544223721726812*^9}, {3.544284938247917*^9, 
  3.544284965339917*^9}, {3.5442850077469177`*^9, 3.544285256275917*^9}}],

Cell[TextData[{
 "To obtain ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", " ", 
     StyleBox["u",
      FontWeight->"Bold"]}], "+", 
    RowBox[{"b", " ", 
     StyleBox["v",
      FontWeight->"Bold"]}]}], TraditionalForm]]],
 ", start at the origin, move ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 " lengths of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " in the direction of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and move ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]]],
 " lengths of ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 " in the direction of ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 ".  It would ",
 StyleBox["not",
  FontVariations->{"Underline"->True}],
 " be possible to obtain all vectors (with base at the origin) as a linear \
combination of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 " if and only if they are parallel."
}], "Text",
 CellChangeTimes->{{3.5442235329750156`*^9, 3.5442237726167226`*^9}, {
  3.544285278570917*^9, 3.5442853300669174`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4", "Subsection",
 CellChangeTimes->{{3.54422479886242*^9, 3.5442248007985315`*^9}}],

Cell[TextData[{
 "Add a line passing through ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 " to the previous graph.  Do not change the above commands.  Enter commands \
below that create a graph of the line and then shows both graphs together."
}], "Text",
 CellChangeTimes->{{3.544224854230587*^9, 3.5442249854930954`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"plot4", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "t"}], ")"}], "u"}], "+", 
      RowBox[{"t", " ", "v"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "m"}], ",", "m"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plot3", ",", "plot4"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5442247035759706`*^9, 3.544224730407505*^9}, {
  3.5442247700887747`*^9, 3.544224773648978*^9}}],

Cell[BoxData[
 GraphicsBox[{{
    {Dashing[{0, Small}], Arrowheads[
     0.02], {ArrowBox[{{-9, 4}, {-8, 2}}], ArrowBox[{{-6, 5}, {-5, 3}}], 
      ArrowBox[{{-3, 6}, {-2, 4}}], ArrowBox[{{0, 7}, {1, 5}}], 
      ArrowBox[{{3, 8}, {4, 6}}]}, {ArrowBox[{{-8, 2}, {-7, 0}}], 
      ArrowBox[{{-5, 3}, {-4, 1}}], ArrowBox[{{-2, 4}, {-1, 2}}], 
      ArrowBox[{{1, 5}, {2, 3}}], ArrowBox[{{4, 6}, {5, 4}}]}, {
      ArrowBox[{{-7, 0}, {-6, -2}}], ArrowBox[{{-4, 1}, {-3, -1}}], 
      ArrowBox[{{-1, 2}, {0, 0}}], ArrowBox[{{2, 3}, {3, 1}}], 
      ArrowBox[{{5, 4}, {6, 2}}]}, {ArrowBox[{{-6, -2}, {-5, -4}}], 
      ArrowBox[{{-3, -1}, {-2, -3}}], ArrowBox[{{0, 0}, {1, -2}}], 
      ArrowBox[{{3, 1}, {4, -1}}], ArrowBox[{{6, 2}, {7, 0}}]}, {
      ArrowBox[{{-5, -4}, {-4, -6}}], ArrowBox[{{-2, -3}, {-1, -5}}], 
      ArrowBox[{{1, -2}, {2, -4}}], ArrowBox[{{4, -1}, {5, -3}}], 
      ArrowBox[{{7, 0}, {8, -2}}]}, {ArrowBox[{{-4, -6}, {-3, -8}}], 
      ArrowBox[{{-1, -5}, {0, -7}}], ArrowBox[{{2, -4}, {3, -6}}], 
      ArrowBox[{{5, -3}, {6, -5}}], ArrowBox[{{8, -2}, {9, -4}}]}, {
      ArrowBox[{{-9, 4}, {-6, 5}}], ArrowBox[{{-6, 5}, {-3, 6}}], 
      ArrowBox[{{-3, 6}, {0, 7}}], ArrowBox[{{0, 7}, {3, 8}}]}, {
      ArrowBox[{{-8, 2}, {-5, 3}}], ArrowBox[{{-5, 3}, {-2, 4}}], 
      ArrowBox[{{-2, 4}, {1, 5}}], ArrowBox[{{1, 5}, {4, 6}}]}, {
      ArrowBox[{{-7, 0}, {-4, 1}}], ArrowBox[{{-4, 1}, {-1, 2}}], 
      ArrowBox[{{-1, 2}, {2, 3}}], ArrowBox[{{2, 3}, {5, 4}}]}, {
      ArrowBox[{{-6, -2}, {-3, -1}}], ArrowBox[{{-3, -1}, {0, 0}}], 
      ArrowBox[{{0, 0}, {3, 1}}], ArrowBox[{{3, 1}, {6, 2}}]}, {
      ArrowBox[{{-5, -4}, {-2, -3}}], ArrowBox[{{-2, -3}, {1, -2}}], 
      ArrowBox[{{1, -2}, {4, -1}}], ArrowBox[{{4, -1}, {7, 0}}]}, {
      ArrowBox[{{-4, -6}, {-1, -5}}], ArrowBox[{{-1, -5}, {2, -4}}], 
      ArrowBox[{{2, -4}, {5, -3}}], ArrowBox[{{5, -3}, {8, -2}}]}, {
      ArrowBox[{{-3, -8}, {0, -7}}], ArrowBox[{{0, -7}, {3, -6}}], 
      ArrowBox[{{3, -6}, {6, -5}}], ArrowBox[{{6, -5}, {9, -4}}]}}, 
    {Thickness[Large], Dashing[{}], Arrowheads[0.03], InsetBox[
      StyleBox["\<\"u\"\>",
       StripOnInput->False,
       FontSize->Larger,
       FontWeight->Bold], {1.1, -2.2},
      Background->GrayLevel[1]], ArrowBox[{{0, 0}, {1, -2}}], InsetBox[
      StyleBox["\<\"v\"\>",
       StripOnInput->False,
       FontSize->Larger,
       FontWeight->Bold], {3.3000000000000003`, 1.1},
      Background->GrayLevel[1]], ArrowBox[{{0, 0}, {3, 1}}], InsetBox[
      StyleBox["\<\"au+bv\"\>",
       StripOnInput->False,
       FontSize->Larger,
       FontWeight->Bold], {-1.1, -5.5},
      Background->GrayLevel[1]], ArrowBox[{{0, 0}, {-1, -5}}]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxF1H8w1HkYwPG1LWr9yNplt+9nV2y71cb2Q7Up9H1ypSKMVXeIatjMNoVS
bRfpx1V75+eJqDMXVxupZNgMGen7CclxruLqUOd3xVHRyiJ7XTc13TPzzHvm
Nc/fj0NYtHwnnUaj+Xzc//ppOPhT52Ktd6LMdYqN7916qXQyiHH4OU6kapyN
E/c9eBQ4Kca1CyXtQ8NszO7N0ZSMirE6VF7a1s3G4jr39eEDYmxReVl5s4aN
vZLjUuuaxZiv2vgo4ns2zuTp+Sl5YiwbSr/UZMnGkiWvVxLeYuy2ePyY/wxr
LBVNzjaoRVhrX7NdYsPC6sBm084Hc3DExerNjWIrbD5x5lggfw5u1M2fsX6t
Jd6zNVqTHSTENwznInO3m2OHD7xfn2ocsLT8+nqFnIlLFF3ZzzvssejM/E1V
vtNxlOzHKbXAHhtq9m65E2mC/0nnYN9mO6zKD/3DUcHAf7p5dtp7C3BTt03g
mng6Dt5lRR/5C+Ec9xUmg7k0vDzq6trhQwTmpE8G0JcZqLqx+M7jOh4uDhbk
HY2coOj0wfiZCVz8w3cJ3S1b3lG6tIwDi2i2eNPg/Rh//xHKbZyZdPQoBxeY
rUKrRYPU4h4ir9GWjRd8UM1LmtZLtfpFcK+lsfC3hdUpw+1PKEfwSlGLrHBX
qO5FRUEFFaFsKetfaoGLdR9S+vbXkBKj4nShlInNGWHdzfWt5OrcqoOBwab4
xga/l/NS+0hqrceMEi8GbnDEXp7SITLzjV5jHG2E1Z6edGbLCCnLypra+5WB
esPt1Z3rekfyQhyt+Yv0VMaKgaePCybIPCehjPpuhJrS57WuqjaQ5jxLlV/F
C6rKdQN27aOBaOmFKWefx1S2MGamtpYO+O1PmUmnM8i2IH1/ZRMD5srOD/5+
uY2UuZRUCUpNYLX/vBitSz9JjBkpB9Omg3+PsUu1doRUMIp+3pTFBCcL5pPn
1XqyoSL1N+PD5rBNWriTtdtAnqUa1PJTlrBt9uKGuDojcC8T5MTJrOCWMKg9
RsMA1ZGLvdPmsiDsYN81sxhT6Ppb/vqxxBp+weMNJ+KZ0FaYMxbAZ0OiybPe
95stgM7l1aI5HDglFOVfXWYFb4dDjswS28CeXUmr8stZEGPn5lxjYwvXpMGN
l+3ZIBzdcKOM4IJz1Ktp1gUc2CEYFn9tyQMrp36XEx/vFGVhCY4GHmSxOL53
47iQradrvWgEROxnmO2lzYJtye6tNm8JSJaH1NrvJsAp69lxnzECPLq91hzY
R8D73DjJ6UkC9NEr79w/RMD5mxWxo3QEihTbW1GnCGhpXy5oYSNwrX94/fYF
AtZJFoalLUcw4L4uI/AhAdI6uyHmYfTFpx5UnfWIRzBZzu/sdUXQ0BbiHnsC
QbGnWcgKDwTKV9mpAwkI+Ir+LR2+CDQc7pL6bAS6nEsbnZQIbMNnqk7fRnDp
sz/fU2RXhREEaYyL0EUEpSqf+6O1CCydRxdEX0EQkJjEUzQhiPN7JLItRZBc
Ylrp0YFA/tm3VuaHx/YgMJ0Vm1negmDBvXXm2hcI7lxRWpu1I7jXejLU4Q0C
yWc/2yM0CdIh6AhYlmD8CkHY0N2iNP3/vnRsxzf17xF472OdLJxA8Olv8b/0
Xzo7I/A=
      "]]}}},
  Axes->True,
  ImageSize->{182.00000000000009`, Automatic}]], "Output",
 CellChangeTimes->{3.5442247336966934`*^9, 3.5442247750360575`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vectors in Three Dimensions", "Section",
 CellChangeTimes->{{3.5442238479500313`*^9, 3.5442238547164183`*^9}}],

Cell[CellGroupData[{

Cell["Exercise 5", "Subsection",
 CellChangeTimes->{{3.5442854817239175`*^9, 3.5442854844989176`*^9}}],

Cell[TextData[{
 "Add to the above graph the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", "=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], ",", 
      RowBox[{"-", "5"}], ",", 
      RowBox[{"-", "8"}]}], ")"}]}], TraditionalForm]]],
 " and the line segments ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["ab", "_"], TraditionalForm]],
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox[
     StyleBox["bc",
      FontSlant->"Italic"], "_"],
    FontSlant->"Italic"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox[
     StyleBox["ca",
      FontSlant->"Italic"], "_"],
    FontSlant->"Italic"], TraditionalForm]]],
 ".  Explain in what way the hand sketch looks different and why."
}], "Text",
 CellChangeTimes->{{3.5442854998039174`*^9, 3.5442855312509174`*^9}, {
  3.5442857787319174`*^9, 3.5442859677640142`*^9}, {3.5442860469699345`*^9, 
  3.5442860929975367`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "5"}], ",", 
     RowBox[{"-", "8"}]}], "}"}]}], ";", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
        RowBox[{"-", "2"}], ",", "7"}], "]"}], ",", 
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<y\>\"", ",", 
        RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
        RowBox[{"-", "5"}], ",", "7"}], "]"}], ",", 
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
        RowBox[{"-", "9"}], ",", "8"}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{"a", ",", "Black"}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{"b", ",", "Black"}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{"c", ",", "Black"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{"a", ",", "c"}], "}"}], "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{"b", ",", "c"}], "}"}], "]"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544188998883645*^9, 3.544189003768761*^9}, {
   3.5441897207364597`*^9, 3.5441897323461676`*^9}, {3.544190060055626*^9, 
   3.54419009446349*^9}, {3.5441901254087315`*^9, 3.5441901463092475`*^9}, {
   3.544190177415721*^9, 3.5441902335381937`*^9}, 3.5441902947152634`*^9, {
   3.5441904213970203`*^9, 3.5441904708429275`*^9}, {3.544191432467061*^9, 
   3.5441914326231127`*^9}, {3.544191466267708*^9, 3.544191473633315*^9}, 
   3.5441915498818345`*^9, {3.5441915858838005`*^9, 3.544191637041529*^9}, {
   3.5441952332194257`*^9, 3.5441952922172594`*^9}, {3.544227068842256*^9, 
   3.5442270705913563`*^9}, {3.544227108415519*^9, 3.544227136351117*^9}, {
   3.54422717940758*^9, 3.544227211334406*^9}, {3.544227258272091*^9, 
   3.5442272583830967`*^9}, {3.544264576475616*^9, 3.544264578367724*^9}, {
   3.544264611410614*^9, 3.5442647285733156`*^9}, {3.5442655755097575`*^9, 
   3.5442656265276756`*^9}, {3.544265668290064*^9, 3.5442656717772636`*^9}, {
   3.5442657178929014`*^9, 3.5442657435013657`*^9}, {3.5442683095971384`*^9, 
   3.544268333300494*^9}, {3.544268372027709*^9, 3.5442684125960293`*^9}, {
   3.544271170958799*^9, 3.5442711717258425`*^9}, {3.5442792389278936`*^9, 
   3.544279242872288*^9}, {3.544279277134714*^9, 3.5442792808680873`*^9}, {
   3.5442793221212125`*^9, 3.54427934140314*^9}, 3.54428111298731*^9, {
   3.544284734286769*^9, 3.544284743923805*^9}, 3.5442855764729176`*^9, {
   3.5442856103849173`*^9, 3.5442856393849173`*^9}, {3.5442857099219174`*^9, 
   3.544285723360917*^9}, {3.544286375169751*^9, 3.5442864053797717`*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], Text3DBox[
    FormBox["\<\"x\"\>", StandardForm], {7.3500000000000005`, 0., 0.}], 
   {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {7, 0, 0}}], 
    {Dashing[{Small, Small}], Line3DBox[{{-2, 0, 0}, {0, 0, 0}}]}, 
    {RGBColor[
      NCache[
       Rational[2, 3], 0.6666666666666666], 
      NCache[
       Rational[2, 3], 0.6666666666666666], 0], Dashing[{}], Text3DBox[
      FormBox["\<\"y\"\>", StandardForm], {0., 7.3500000000000005`, 0.}], 
     {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 7, 0}}], 
      {Dashing[{Small, Small}], Line3DBox[{{0, -5, 0}, {0, 0, 0}}]}, 
      {RGBColor[0, 1, 0], Dashing[{}], Text3DBox[
        FormBox["\<\"z\"\>", StandardForm], {0., 0., 8.4}], 
       {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 8}}], 
        {Dashing[{Small, Small}], Line3DBox[{{0, 0, -9}, {0, 0, 0}}]}, 
        {GrayLevel[0], Dashing[{Small, Small}], 
         Line3DBox[{{3, 0, 0}, {3, 0, 0}, {3, 0, 1}}], 
         {PointSize[Medium], Point3DBox[{3, 0, 1}], 
          {GrayLevel[0], Dashing[{Small, Small}], 
           Line3DBox[{{2, 0, 0}, {2, 3, 0}, {2, 3, 5}}], 
           {PointSize[Medium], Point3DBox[{2, 3, 5}], 
            {GrayLevel[0], Dashing[{Small, Small}], 
             Line3DBox[{{-2, 0, 0}, {-2, -5, 0}, {-2, -5, -8}}], 
             {PointSize[Medium], Point3DBox[{-2, -5, -8}], 
              {RGBColor[0, 0, 1], Dashing[{}], 
               Line3DBox[{{3, 0, 1}, {2, 3, 5}}], 
               Line3DBox[{{3, 0, 1}, {-2, -5, -8}}], 
               Line3DBox[{{2, 3, 5}, {-2, -5, -8}}]}}}}}}}}}}}}},
  Axes->True,
  ImageSize->{182.79692592702392`, Automatic},
  ViewPoint->{100, 100, 100}]], "Output",
 CellChangeTimes->{3.544286127325969*^9, 3.544286380298264*^9, 
  3.544286411549389*^9}]
}, Open  ]],

Cell[TextData[{
 "The hand sketch x-axis scale is not linear (0 to 1 is longer than 1 to 2) \
while the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " scales are linear.  "
}], "Text",
 CellChangeTimes->{{3.5442861461798544`*^9, 3.5442862601192474`*^9}, 
   3.5442864385370874`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6", "Subsection",
 CellChangeTimes->{{3.5442864645226855`*^9, 3.5442864672429576`*^9}}],

Cell[TextData[{
 "Graph the three axes to match the view point given in this diagram.\n  ",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJzt3D1PG1kYhuEj7TSUadIvHRX9dlugNFRu6OPCjaWVVoo0XSoXpN1iXbqI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     "], {{0, 193}, {224, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   BaseStyle->"ImageGraphics",
   ImageSize->{123.99999999999967`, Automatic},
   ImageSizeRaw->{224, 193},
   PlotRange->{{0, 224}, {0, 193}}]],
  CellChangeTimes->{
   3.544195665069894*^9, {3.5441956963549113`*^9, 3.5441957758713474`*^9}, {
    3.5441958068765025`*^9, 3.544195821559396*^9}, {3.544195858774744*^9, 
    3.544195863362173*^9}}]
}], "Text",
 CellChangeTimes->{{3.5442864799402275`*^9, 3.544286487276961*^9}, {
  3.544286853217551*^9, 3.544286897661995*^9}, {3.5442869853037586`*^9, 
  3.5442870219774256`*^9}, {3.544287111396366*^9, 3.544287111803407*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", "Thick", "}"}], ",", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", "0", ",", "2"}], 
      "]"}], ",", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<y\>\"", ",", 
       RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", "0", ",", "2"}],
       "]"}], ",", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", "0", ",", "4"}], 
      "]"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100", ",", 
      RowBox[{"-", "100"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5442794950785065`*^9, 3.54427954061806*^9}, {
   3.544279573998398*^9, 3.5442795753415318`*^9}, {3.544286568354068*^9, 
   3.5442866234715786`*^9}, 3.544286663667598*^9, {3.544286694422673*^9, 
   3.5442867254807787`*^9}, {3.5442868018254128`*^9, 3.54428681980221*^9}, {
   3.544286902155444*^9, 3.544286908259055*^9}, {3.544287032672495*^9, 
   3.544287092765504*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], Thickness[Large], Text3DBox[
    FormBox["\<\"x\"\>", StandardForm], {2.1, 0., 0.}], 
   {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {2, 0, 0}}], 
    {RGBColor[
      NCache[
       Rational[2, 3], 0.6666666666666666], 
      NCache[
       Rational[2, 3], 0.6666666666666666], 0], Text3DBox[
      FormBox["\<\"y\"\>", StandardForm], {0., 2.1, 0.}], 
     {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 2, 0}}], 
      {RGBColor[0, 1, 0], Text3DBox[
        FormBox["\<\"z\"\>", StandardForm], {0., 0., 4.2}], 
       {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 4}}]}}}}}},
  Axes->True,
  ImageSize->{163.18440211923536`, Automatic},
  ViewPoint->{100, 100, -100}]], "Output",
 CellChangeTimes->{{3.544286546357868*^9, 3.5442866245636883`*^9}, 
   3.54428666448368*^9, {3.5442866980930405`*^9, 3.544286726175848*^9}, {
   3.5442868027745075`*^9, 3.544286820425272*^9}, 3.544286913771606*^9, {
   3.544287044505678*^9, 3.544287093421569*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lines in Three Dimensions", "Section",
 CellChangeTimes->{{3.544287151727399*^9, 3.544287159864213*^9}, {
  3.544288306376198*^9, 3.544288308352*^9}}],

Cell[CellGroupData[{

Cell["Exercise 7", "Subsection",
 CellChangeTimes->{{3.544289255654543*^9, 3.544289263358543*^9}}],

Cell[TextData[{
 "Choose a variety of values for ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]]],
 " in the above manipulator to investigate the following.  Give a precise \
geometric description of the vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["r",
      FontWeight->"Bold"], "(", "t", ")"}], "=", 
    RowBox[{
     SubscriptBox["P", "0"], "+", 
     RowBox[{"t", " ", 
      StyleBox["v",
       FontWeight->"Bold"]}]}]}], TraditionalForm]]],
 ". "
}], "Text",
 CellChangeTimes->{{3.5442892673215427`*^9, 3.5442892981835427`*^9}, {
  3.5442893996575427`*^9, 3.544289419817543*^9}}],

Cell[TextData[{
 "To obtain ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["r",
     FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
 ", start at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "0"], TraditionalForm]]],
 " and move ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]]],
 " lengths of ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 " in the direction of ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 ".  "
}], "Text",
 CellChangeTimes->{
  3.544289362338543*^9, {3.5442894526465425`*^9, 3.5442895083515425`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8", "Subsection",
 CellChangeTimes->{{3.544289534902543*^9, 3.5442895364865427`*^9}}],

Cell[TextData[{
 "Graph the lines ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["r",
       FontWeight->"Bold"], "1"], "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"1", ",", "0", ",", "1"}], "\[RightAngleBracket]"}], "+", 
     RowBox[{"t", 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"3", ",", "3", ",", "5"}], "\[RightAngleBracket]"}]}]}]}], 
   TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["r",
       FontWeight->"Bold"], "2"], "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"3", ",", "6", ",", "1"}], "\[RightAngleBracket]"}], "+", 
     RowBox[{"t", 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"4", ",", 
        RowBox[{"-", "2"}], ",", "7"}], "\[RightAngleBracket]"}]}]}]}], 
   TraditionalForm]]],
 " in a manner that makes it clear that the two lines either do or do not \
intersect.  See Section 13.2 Example 5."
}], "Text",
 CellChangeTimes->{{3.544289548350543*^9, 3.5442896890385427`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], ";", 
  RowBox[{"v1", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "5"}], "}"}]}], ";", 
  RowBox[{"p2", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "6", ",", "1"}], "}"}]}], ";", 
  RowBox[{"v2", "=", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"-", "2"}], ",", "7"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Join", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<y\>\"", ",", 
       RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p1", "-", 
           RowBox[{"3", "v1"}]}], ",", 
          RowBox[{"p1", "+", 
           RowBox[{"3", "v1"}]}]}], "}"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p2", "-", 
           RowBox[{"2", "v2"}]}], ",", 
          RowBox[{"p2", "+", 
           RowBox[{"2", "v2"}]}]}], "}"}], "]"}]}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5442897223965425`*^9, 3.544289759185543*^9}, {
  3.5442897953635426`*^9, 3.5442898635405426`*^9}, {3.544290302780543*^9, 
  3.5442903298685427`*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], Text3DBox[
    FormBox["\<\"x\"\>", StandardForm], {5.25, 0., 0.}], 
   {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {5, 0, 0}}], 
    {Dashing[{Small, Small}], Line3DBox[{{-5, 0, 0}, {0, 0, 0}}]}, 
    {RGBColor[
      NCache[
       Rational[2, 3], 0.6666666666666666], 
      NCache[
       Rational[2, 3], 0.6666666666666666], 0], Dashing[{}], Text3DBox[
      FormBox["\<\"y\"\>", StandardForm], {0., 5.25, 0.}], 
     {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 5, 0}}], 
      {Dashing[{Small, Small}], Line3DBox[{{0, -5, 0}, {0, 0, 0}}]}, 
      {RGBColor[0, 1, 0], Dashing[{}], Text3DBox[
        FormBox["\<\"z\"\>", StandardForm], {0., 0., 5.25}], 
       {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 5}}], 
        {Dashing[{Small, Small}], Line3DBox[{{0, 0, -5}, {0, 0, 0}}]}, 
        {GrayLevel[0], Dashing[{}], Line3DBox[{{-8, -9, -14}, {10, 9, 16}}], 
         {RGBColor[0, 0, 1], Line3DBox[{{-5, 10, -13}, {11, 2, 15}}]}}}}}}}},
  Axes->True,
  ImageSize->{217.95254283505014`, 306.6666666666667},
  ViewPoint->{78.38809573009736, 101.26379272815812`, 116.6231140474208},
  ViewVertical->{-0.47775964431120466`, -0.8248118934343162, 
   0.7972219916970091}]], "Output",
 CellChangeTimes->{{3.544289836544543*^9, 3.544289864694543*^9}, 
   3.5442903373285427`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{905, 800},
WindowMargins->{{-8, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 95, 1, 137, "Title"],
Cell[677, 25, 232, 5, 76, "Text"],
Cell[CellGroupData[{
Cell[934, 34, 164, 5, 119, "Section"],
Cell[CellGroupData[{
Cell[1123, 43, 98, 1, 65, "Subsection"],
Cell[1224, 46, 1143, 42, 114, "Text"],
Cell[CellGroupData[{
Cell[2392, 92, 787, 22, 171, "Input"],
Cell[3182, 116, 147, 3, 43, "Output"],
Cell[3332, 121, 111, 1, 43, "Output"],
Cell[3446, 124, 9488, 161, 195, "Output"],
Cell[12937, 287, 192, 5, 66, "Output"],
Cell[13132, 294, 141, 3, 60, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13322, 303, 98, 1, 121, "Subsection"],
Cell[13423, 306, 337, 11, 94, "Text"],
Cell[CellGroupData[{
Cell[13785, 321, 155, 4, 96, "Input"],
Cell[13943, 327, 423, 9, 73, "Message"],
Cell[14369, 338, 273, 9, 108, "Output"]
}, Open  ]],
Cell[14657, 350, 810, 23, 301, "Text"],
Cell[CellGroupData[{
Cell[15492, 377, 233, 6, 96, "Input"],
Cell[15728, 385, 139, 3, 94, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15928, 395, 158, 2, 235, "Section"],
Cell[CellGroupData[{
Cell[16111, 401, 100, 1, 121, "Subsection"],
Cell[16214, 404, 1406, 51, 265, "Text"],
Cell[17623, 457, 1351, 54, 208, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19011, 516, 99, 1, 121, "Subsection"],
Cell[19113, 519, 468, 14, 150, "Text"],
Cell[CellGroupData[{
Cell[19606, 537, 569, 17, 159, "Input"],
Cell[20178, 556, 4559, 80, 694, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24798, 643, 116, 1, 235, "Section"],
Cell[CellGroupData[{
Cell[24939, 648, 102, 1, 121, "Subsection"],
Cell[25044, 651, 969, 35, 153, "Text"],
Cell[CellGroupData[{
Cell[26038, 690, 3117, 63, 463, "Input"],
Cell[29158, 755, 1788, 35, 946, "Output"]
}, Open  ]],
Cell[30961, 793, 290, 8, 148, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31288, 806, 102, 1, 121, "Subsection"],
Cell[31393, 809, 3019, 55, 463, "Text"],
Cell[CellGroupData[{
Cell[34437, 868, 1134, 26, 220, "Input"],
Cell[35574, 896, 1000, 21, 996, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36635, 924, 156, 2, 235, "Section"],
Cell[CellGroupData[{
Cell[36816, 930, 98, 1, 121, "Subsection"],
Cell[36917, 933, 621, 20, 148, "Text"],
Cell[37541, 955, 636, 27, 94, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38214, 987, 100, 1, 121, "Subsection"],
Cell[38317, 990, 1117, 35, 148, "Text"],
Cell[CellGroupData[{
Cell[39459, 1029, 2064, 55, 585, "Input"],
Cell[41526, 1086, 1338, 26, 1084, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
